/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdExprNodeBase;
import com.ibm.debug.pdt.internal.epdc.EStdGenericNode;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class EStdTreeNode
extends EStdExprNodeBase {
    private int _level;
    private int _numChild;
    private EStdGenericNode _nodeData;
    private ArrayList<EStdTreeNode> _children;
    private static final EStdTreeNode[] EMPTYNODES = new EStdTreeNode[0];
    private int _offsetNextSibling;
    private int _numChildren;

    public EStdTreeNode(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._nodeID = dataInputStream.readInt();
        this._level = dataInputStream.readUnsignedShort();
        this._numChild = dataInputStream.readUnsignedShort() - 1;
        this._numChildren = dataInputStream.readUnsignedShort();
        if (this._numChildren > 0) {
            this._children = new ArrayList(this._numChildren);
        }
        if (this.getEPDCVersion() > 306) {
            this._languageID = dataInputStream.readByte();
            this._typeIndex = dataInputStream.readByte();
        } else {
            dataInputStream.skipBytes(2);
        }
        dataInputStream.skipBytes(4);
        int firstChildOffset = dataInputStream.readInt();
        if (firstChildOffset != 0) {
            int nextSiblingOffset;
            EStdTreeNode childNode = new EStdTreeNode(byteBuffer, new OffsetDataInputStream(byteBuffer, firstChildOffset), engineSession);
            childNode.setParentID(this._nodeID);
            this._children.add(childNode);
            while ((nextSiblingOffset = childNode.getNextSiblingOffset()) != 0) {
                childNode = new EStdTreeNode(byteBuffer, new OffsetDataInputStream(byteBuffer, nextSiblingOffset), engineSession);
                childNode.setParentID(this._nodeID);
                this._children.add(childNode);
            }
        }
        dataInputStream.skipBytes(8);
        this._offsetNextSibling = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        int offset = dataInputStream.readInt();
        this._nodeData = EStdGenericNode.decodeEStdGenericNodeStream(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
    }

    public EStdGenericNode getTreeNodeData() {
        return this._nodeData;
    }

    public EStdTreeNode[] getNodes() {
        if (this._children == null) {
            return EMPTYNODES;
        }
        return this._children.toArray(new EStdTreeNode[this._children.size()]);
    }

    @Override
    public int getChildNum() {
        return this._numChild;
    }

    private int getNextSiblingOffset() {
        return this._offsetNextSibling;
    }

    @Override
    public String getName() {
        return this._nodeData.getName();
    }

    @Override
    public String getType() {
        return this._nodeData.getType();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Node_ID", this.getId());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Level_Of_Node", this._level);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Index", this.getChildNum());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "# of children returned", this.getNumChildren());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Language_ID", this.getLanguageID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type_Index", this.getTypeIndex());
        if (this._nodeData != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Node_Data");
            this._nodeData.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Node_Data", "NULL");
        }
        EStdTreeNode[] nodes = this.getNodes();
        if (nodes.length > 0) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Child nodes[" + nodes.length + "]");
            int maxNodePrint = Math.min(nodes.length, 10);
            int i = 0;
            while (i < maxNodePrint) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Node[" + nodes[i].getId() + "]");
                nodes[i].writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }

    @Override
    public boolean hasChildren() {
        return this._numChildren > 0;
    }

    @Override
    public int getNumChildren() {
        return this._numChildren;
    }

    public void addNodes(List<EStdTreeNode> nodeList) {
        if (!this.hasChildren()) {
            return;
        }
        EStdTreeNode[] nodes = this.getNodes();
        int i = 0;
        while (i < nodes.length) {
            nodeList.add(nodes[i]);
            nodes[i].addNodes(nodeList);
            ++i;
        }
    }

    @Override
    public int getBaseIndex() {
        return 0;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isValueChanged() {
        return true;
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Standard Tree node (<310)";
    }
}

