/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdTraceEntry
extends EPDC_Structures {
    private int fType;
    private int fModuleId;
    private int fPartId;
    private int fEntryId;
    private int fViewFileId;
    private int fLineNumber;
    private int fElapsedTime;
    private int fCPUTime;
    private EStdString fAdditionalInformation;

    public EStdTraceEntry(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this.fType = dis.readInt();
        this.fModuleId = dis.readInt();
        this.fPartId = dis.readInt();
        this.fEntryId = dis.readInt();
        this.fViewFileId = dis.readInt();
        this.fLineNumber = dis.readInt();
        this.fElapsedTime = dis.readInt();
        this.fCPUTime = dis.readInt();
        int offset = dis.readInt();
        if (offset != 0) {
            this.fAdditionalInformation = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
            int stringLength = 2 + this.fAdditionalInformation.length();
            dis.skipBytes(stringLength);
        }
    }

    public int getType() {
        return this.fType;
    }

    public int getModuleId() {
        return this.fModuleId;
    }

    public int getPartId() {
        return this.fPartId;
    }

    public int getEntryId() {
        return this.fEntryId;
    }

    public int getViewFileId() {
        return this.fViewFileId;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getElapsedTime() {
        return this.fElapsedTime;
    }

    public int getCPUTime() {
        return this.fCPUTime;
    }

    public String getAdditionalInformation() {
        return this.fAdditionalInformation.toString();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        String value = String.valueOf(this.fLineNumber) + ", " + String.valueOf(this.fElapsedTime) + ", " + String.valueOf(this.fCPUTime);
        EPDC_DumpUtils.writeVariable(dataOutputStream, String.format("T:%d M:%d P:%d E:%d VF:%d", this.fType, this.fModuleId, this.fPartId, this.fEntryId, this.fViewFileId), value);
    }

    @Override
    public String getDescription() {
        return "Trace entry";
    }
}

