/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdTraceBinaryEntry
extends EPDC_Structures {
    private static final byte COMPRESSED = 1;
    private byte fFlags;
    private byte[] fData;

    protected EStdTraceBinaryEntry(DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        this.fFlags = dataInputStream.readByte();
        if (dataInputStream.skipBytes(3) != 3) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in EStdTraceBinaryEntry.", 2);
        }
        int length = dataInputStream.readInt();
        this.fData = new byte[length];
        dataInputStream.readFully(this.fData);
    }

    public boolean isCompressed() {
        return (this.fFlags & 1) != 0;
    }

    public byte[] getData() {
        return this.fData;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] flags = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "Compressed")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Flags", this.fFlags, flags);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Length", this.fData.length);
        EPDC_DumpUtils.writeBytes(dataOutputStream, "Content", this.fData, 0);
    }

    @Override
    public String getDescription() {
        return "Binary Trace Data";
    }
}

