/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdTargetBranchPoint
extends EPDC_Structures {
    private int fId;
    private int fTargetStartLine;
    private int fTargetEndLine;
    private int fTargetEndColumn;
    private int fTargetStartColumn;

    public EStdTargetBranchPoint(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this.fId = dis.readInt();
        this.fTargetStartLine = dis.readInt();
        this.fTargetEndLine = dis.readInt();
        this.fTargetStartColumn = dis.readInt();
        this.fTargetEndColumn = dis.readInt();
        dis.readInt();
    }

    public int getId() {
        return this.fId;
    }

    public int getStartLine() {
        return this.fTargetStartLine;
    }

    public int getEndLine() {
        return this.fTargetEndLine;
    }

    public int getStartColumn() {
        return this.fTargetStartColumn;
    }

    public int getEndColumn() {
        return this.fTargetEndColumn;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, String.format("ID=%d First/Last Line=%d/%d First/Last Column=%d/%d", this.fId, this.fTargetStartLine, this.fTargetEndLine, this.fTargetStartColumn, this.fTargetEndColumn), this.fId);
    }

    @Override
    public String getDescription() {
        return "Target Branch Point";
    }
}

