/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.epdc.IFormattedString;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class EStdString
extends EPDC_Structures
implements Serializable {
    private static final String ERROR_STRING = "**ERROR decoding EStdString**";
    private static final long serialVersionUID = 20050124L;
    private transient char[] _string = "".toCharArray();
    private boolean _specialFormat = false;
    private int _len = 0;
    private byte[] _buffer = null;

    EStdString(char[] string, EPDC_EngineSession engineSession) {
        super(engineSession);
        if (string != null) {
            try {
                this._string = string;
                this._buffer = String.valueOf(string).getBytes("UTF-8");
                this._len = this._buffer.length;
            }
            catch (UnsupportedEncodingException e) {
                PDTCoreUtils.logError(e);
            }
        }
    }

    EStdString(String string, EPDC_EngineSession engineSession) {
        this(string == null ? null : string.toCharArray(), engineSession);
    }

    EStdString(DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this._len = dataInputStream.readShort();
        if (this._len == 0) {
            return;
        }
        if (this._len < 0) {
            if (engineSession == null) {
                this._len = Short.MAX_VALUE;
            } else {
                this._specialFormat = true;
                this._len = Math.abs(this._len);
            }
        }
        this._buffer = new byte[this._len];
        int bytesRead = dataInputStream.read(this._buffer);
        if (bytesRead < this._len && bytesRead != -1) {
            this._buffer = Arrays.copyOf(this._buffer, bytesRead);
            PDTCoreUtils.logString(this, String.format("String truncated because length (%d) does not match number of bytes (%d) in stream", this._len, bytesRead), 2);
        }
        if (this._buffer.length != 0) {
            this._string = this.decode(this._buffer, this._specialFormat, engineSession);
        }
    }

    public EStdString(boolean specialFormat, int len, byte[] buffer, String cachedString) {
        this._specialFormat = specialFormat;
        this._len = len;
        this._buffer = buffer;
        this._string = cachedString == null ? this.decode(buffer, specialFormat, null) : cachedString.toCharArray();
    }

    private char[] decode(byte[] buffer, boolean specialFormat, EPDC_EngineSession engineSession) {
        String string = ERROR_STRING;
        if (specialFormat) {
            IFormattedString fmtCls;
            IFormattedString iFormattedString = fmtCls = engineSession == null ? null : engineSession.getFormattingClass();
            if (fmtCls != null) {
                try {
                    string = fmtCls.decodeString(buffer);
                }
                catch (Exception e) {
                    PDTCoreUtils.logError(e);
                }
            }
        } else {
            try {
                string = new String(buffer, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                PDTCoreUtils.logError(e);
            }
        }
        return string.toCharArray();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        dataOutputStream.writeShort(this._buffer.length);
        dataOutputStream.write(this._buffer);
    }

    private boolean isEmpty() {
        return this._buffer == null || this._buffer.length == 0;
    }

    @Override
    public String toString() {
        return String.valueOf(this._string);
    }

    public int length() {
        return this._string.length;
    }

    public static String toString(EStdString convertMe) {
        return convertMe == null || convertMe.isEmpty() ? null : convertMe.toString();
    }

    @Override
    int getFixedLen() {
        return 2;
    }

    @Override
    int getVarLen() {
        if (this.isEmpty()) {
            return 0;
        }
        return this._buffer.length;
    }

    public boolean isSpecialFormat() {
        return this._specialFormat;
    }

    @Override
    int getTotalBytes() {
        if (this.isEmpty()) {
            return 0;
        }
        return super.getTotalBytes();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "(" + this._buffer.length + ")", this.toString());
    }

    public int getBufferLength() {
        return this._len;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public String getCachedString() {
        return String.valueOf(this._string);
    }

    @Override
    public String getDescription() {
        return "Standard string";
    }
}

