/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdStorageSegment
extends EPDC_Structures {
    private static final byte STORAGE_INVALID = 0;
    private static final byte STORAGE_READABLE = 1;
    private static final byte STORAGE_WRITEABLE = 2;
    private static final byte STORAGE_EXECUTABLE = 4;
    private static final byte STORAGE_NOTAUTHORIZED = 8;
    private int _numOfBytes;
    private byte _attributes;
    private byte[] _storage;

    public EStdStorageSegment(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._numOfBytes = dataInputStream.readInt();
        this._attributes = dataInputStream.readByte();
        dataInputStream.skipBytes(11);
        this._storage = new byte[this._numOfBytes];
        if (!this.isInvalid()) {
            dataInputStream.read(this._storage);
        }
    }

    public int getNumBytes() {
        return this._numOfBytes;
    }

    public byte[] getBytes() {
        return this._storage;
    }

    public boolean isReadable() {
        return (this._attributes & 1) != 0;
    }

    public boolean isInvalid() {
        return this._attributes == 0;
    }

    public boolean isWriteable() {
        return (this._attributes & 2) != 0;
    }

    public boolean isExecutable() {
        return (this._attributes & 4) != 0;
    }

    public boolean isNotAuthorized() {
        return (this._attributes & 8) != 0;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] constants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(0, "STORAGE_INVALID"), new EPDC_DumpUtils.NameVal(1, "STORAGE_READABLE"), new EPDC_DumpUtils.NameVal(2, "STORAGE_WRITEABLE"), new EPDC_DumpUtils.NameVal(4, "STORAGE_EXECUTABLE")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "number_of_bytes", this._numOfBytes);
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "attributes", this._attributes, constants);
        EPDC_DumpUtils.writeBytes(dataOutputStream, "Storage", this._storage, 0);
    }

    @Override
    public String getDescription() {
        return "Storage segment";
    }
}

