/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@Deprecated
public class EStdStorageLocation
extends EPDC_Structures {
    private EStdString _baseAddress;
    private int _lineOffset;
    private int _unitOffset;
    private static int FIXED_LENGTH = 12;

    public EStdStorageLocation(String baseAddress, int lineOffset, int unitOffset, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._baseAddress = new EStdString(baseAddress, engineSession);
        this._lineOffset = lineOffset;
        this._unitOffset = unitOffset;
    }

    EStdStorageLocation(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._baseAddress = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._lineOffset = dataInputStream.readInt();
        this._unitOffset = dataInputStream.readInt();
    }

    public void output(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        this.outputFixedPart(dataOutputStream, baseOffset);
        this.outputVariablePart(dataOutputStream);
    }

    public void outputFixedPart(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        EStdStorageLocation.writeOffsetOrZero(dataOutputStream, baseOffset, this._baseAddress);
        dataOutputStream.writeInt(this._lineOffset);
        dataOutputStream.writeInt(this._unitOffset);
    }

    public void outputVariablePart(DataOutputStream dataOutputStream) throws IOException {
        if (this._baseAddress != null) {
            this._baseAddress.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        return FIXED_LENGTH;
    }

    @Override
    int getVarLen() {
        return EStdStorageLocation.getTotalBytes(this._baseAddress);
    }

    String getAddress() {
        return this._baseAddress.toString();
    }

    int getLineOffset() {
        return this._lineOffset;
    }

    int getUnitOffset() {
        return this._unitOffset;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Base_Address", this.getAddress());
        }
        catch (Exception e) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Base_Address", "NULL");
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Line_offset", this.getLineOffset());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Unit_offset", this.getUnitOffset());
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Storage location";
    }
}

