/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdSourceLine
extends EPDC_Structures {
    private EStdString _sourceLine;
    private byte fFlags;
    private static final int FIXED_LENGTH = 5;

    EStdSourceLine(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, null);
        this.fFlags = dataInputStream.readByte();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._sourceLine = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public String getLineText() {
        if (this._sourceLine != null) {
            return this._sourceLine.toString();
        }
        return null;
    }

    public void removeText() {
        this._sourceLine = null;
    }

    public byte getFlags() {
        return this.fFlags;
    }

    public boolean isExecutable() {
        return (this.fFlags & 0xFFFFFF80) != 0;
    }

    public boolean isLocal() {
        return (this.fFlags & 0x40) != 0;
    }

    @Override
    int getFixedLen() {
        return 5;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EStdSourceLine.getTotalBytes(this._sourceLine);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] lineConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(-128, "SourceLineExecutable"), new EPDC_DumpUtils.NameVal(64, "SourceLineGetLocal")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Source line flags", this.fFlags, lineConstants);
    }

    @Override
    public String getDescription() {
        return "Source line";
    }
}

