/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdMessage;
import com.ibm.debug.pdt.internal.epdc.EStdTargetBranchPoint;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class EStdSourceBranchPoint
extends EPDC_Structures {
    private int fId;
    private int fSourceStartLine;
    private int fSourceEndLine;
    private int fSourceEndColumn;
    private int fSourceStartColumn;
    private EStdMessage fExpression;
    private EStdTargetBranchPoint[] fTargetPoints;

    public EStdSourceBranchPoint(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this.fId = dis.readInt();
        this.fSourceStartLine = dis.readInt();
        this.fSourceEndLine = dis.readInt();
        this.fSourceStartColumn = dis.readInt();
        this.fSourceEndColumn = dis.readInt();
        int offset = dis.readInt();
        if (offset != 0) {
            this.fExpression = new EStdMessage(byteBuffer, dis, engineSession);
        }
        int numTargets = dis.readInt();
        OffsetDataInputStream ois = new OffsetDataInputStream(byteBuffer, dis.readInt());
        this.fTargetPoints = new EStdTargetBranchPoint[numTargets];
        int i = 0;
        while (i < numTargets) {
            this.fTargetPoints[i] = new EStdTargetBranchPoint(byteBuffer, ois, engineSession);
            ++i;
        }
        ois.close();
    }

    public int getId() {
        return this.fId;
    }

    public int getStartLine() {
        return this.fSourceStartLine;
    }

    public int getEndLine() {
        return this.fSourceEndLine;
    }

    public int getStartColumn() {
        return this.fSourceStartColumn;
    }

    public int getEndColumn() {
        return this.fSourceEndColumn;
    }

    public EStdTargetBranchPoint[] getTargetBranchPoints() {
        return Arrays.copyOf(this.fTargetPoints, this.fTargetPoints.length);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, String.format("Items[%d] ID=%d First/Last Line=%d/%d First/Last Column=%d/%d", this.fTargetPoints.length, this.fId, this.fSourceStartLine, this.fSourceEndLine, this.fSourceStartColumn, this.fSourceEndColumn));
        if (this.fExpression != null) {
            this.fExpression.writeEPDC(dataOutputStream);
        }
        EStdTargetBranchPoint[] eStdTargetBranchPointArray = this.fTargetPoints;
        int n = this.fTargetPoints.length;
        int n2 = 0;
        while (n2 < n) {
            EStdTargetBranchPoint element = eStdTargetBranchPointArray[n2];
            element.writeEPDC(dataOutputStream);
            ++n2;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Source Branch Point";
    }
}

