/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EExtString;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdMessage;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdNumberList
extends EPDC_Structures {
    private int fPartId;
    private int fViewId;
    private int fViewFileId;
    private EExtString fLinesAttribute;
    private EStdMessage fMessage;

    public EStdNumberList(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this.fPartId = dis.readInt();
        this.fViewId = dis.readInt();
        this.fViewFileId = dis.readInt();
        int offset = dis.readInt();
        this.fLinesAttribute = new EExtString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        offset = dis.readInt();
        if (offset != 0) {
            this.fMessage = new EStdMessage(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public int getPartId() {
        return this.fPartId;
    }

    public int getViewId() {
        return this.fViewId;
    }

    public int getViewFileId() {
        return this.fViewFileId;
    }

    public String getLinesAttribute() {
        String tempLines;
        if (this.getEPDCEngineSession().isiSeriesEngine() && !(tempLines = this.fLinesAttribute.toString()).isEmpty() && !tempLines.startsWith("#")) {
            String newLines = tempLines.replace(this.fLinesAttribute.toString().charAt(0), '#');
            this.fLinesAttribute = new EExtString(newLines, this.getEPDCEngineSession());
        }
        return this.fLinesAttribute == null ? "!NULL!" : this.fLinesAttribute.toString();
    }

    public EStdMessage getMessage() {
        return this.fMessage;
    }

    @Override
    public void writeEPDC(DataOutputStream dos) throws IOException {
        EPDC_DumpUtils.writeVariable(dos, String.format("P:%d V:%d VF:%d", this.fPartId, this.fViewId, this.fViewFileId), this.fLinesAttribute.toString());
        if (this.fMessage != null) {
            this.fMessage.writeEPDC(dos);
        }
    }

    @Override
    public String getDescription() {
        return "Line attribute";
    }
}

