/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdNameValuePair
extends EPDC_Structures {
    private EStdString fName;
    private EStdString fValue;

    public EStdNameValuePair(String name, String value, EPDC_EngineSession engineSession) {
        super(engineSession);
        this.fName = new EStdString(name, engineSession);
        this.fValue = new EStdString(value, engineSession);
    }

    EStdNameValuePair(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fName = new EStdString(dataInputStream, engineSession);
        this.fValue = new EStdString(dataInputStream, engineSession);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        this.fName.output(dataOutputStream);
        this.fValue.output(dataOutputStream);
    }

    @Override
    int getVarLen() {
        return EStdNameValuePair.getTotalBytes(this.fName) + EStdNameValuePair.getTotalBytes(this.fValue);
    }

    public String getName() {
        if (this.fName == null) {
            return null;
        }
        return this.fName.toString();
    }

    public String getValue() {
        if (this.fValue == null) {
            return null;
        }
        return this.fValue.toString();
    }

    void setName(String newName) {
        this.fName = new EStdString(newName, this.getEPDCEngineSession());
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Name", this.getName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Value", this.getValue());
    }

    @Override
    public String getDescription() {
        return "Name value pair";
    }
}

