/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdEventBPData;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdModuleLoadData
extends EStdEventBPData {
    private static final long serialVersionUID = 20090720L;
    private EStdString fModuleName;
    private boolean fRunToEntry;

    public EStdModuleLoadData(String moduleName, EPDC_EngineSession engineSession, boolean runToEntry) {
        super(engineSession);
        this.fModuleName = new EStdString(moduleName, engineSession);
        this.fRunToEntry = runToEntry;
    }

    EStdModuleLoadData(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession, boolean runToEntry) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fModuleName = new EStdString(dataInputStream, engineSession);
        this.fRunToEntry = runToEntry;
    }

    public EStdString getModuleName() {
        return this.fModuleName;
    }

    @Override
    int getTotalBytes() {
        return this.fModuleName.getTotalBytes();
    }

    @Override
    int getFixedLen() {
        return this.fModuleName.getFixedLen();
    }

    @Override
    int getVarLen() {
        return this.fModuleName.getVarLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        this.fModuleName.output(dataOutputStream);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        this.fModuleName.writeEPDC(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "runToEntry", this.fRunToEntry);
    }

    @Override
    public String getDescription() {
        return "Module Load BP data";
    }
}

