/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdMessage
extends EPDC_Structures {
    private TYPE fType;
    private EStdString fText;
    private static final byte INFO = 1;
    private static final byte WARNING = 2;
    private static final byte ERROR = 3;

    public EStdMessage(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        switch (dis.readByte()) {
            case 1: {
                this.fType = TYPE.INFO;
                break;
            }
            case 2: {
                this.fType = TYPE.WARNING;
                break;
            }
            case 3: {
                this.fType = TYPE.ERROR;
                break;
            }
            default: {
                this.fType = TYPE.NONE;
            }
        }
        dis.skipBytes(3);
        this.fText = new EStdString(dis, engineSession);
    }

    public String getText() {
        return this.fText == null ? "!NULL!" : this.fText.toString();
    }

    public TYPE getType() {
        return this.fType;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type", this.fType.toString());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Message", this.fText);
    }

    @Override
    public String getDescription() {
        return "Message";
    }

    public static enum TYPE {
        NONE,
        INFO,
        WARNING,
        ERROR;

    }
}

