/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.util.IBIDIEngine;
import com.ibm.debug.pdt.internal.epdc.EExtString;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdCmdEchoLine;
import com.ibm.debug.pdt.internal.epdc.EStdCmdLogLine;
import com.ibm.debug.pdt.internal.epdc.EStdHiddenCmdLogLine;
import com.ibm.debug.pdt.internal.epdc.EStdPgmErrorLine;
import com.ibm.debug.pdt.internal.epdc.EStdPgmOutputLine;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class EStdLogLine
extends EPDC_Structures {
    private EExtString _logLine;
    protected int _logLineType;
    private boolean _newLine = true;
    private boolean _bidi = false;
    private IBIDIEngine _bidiEngine = null;

    EStdLogLine(int logType, String logLine, EPDC_EngineSession engineSession, boolean newLine) {
        super(engineSession);
        this._logLineType = logType;
        this._logLine = new EExtString(logLine, engineSession);
        this.init(engineSession, newLine);
    }

    EStdLogLine(DataInputStream dataInputStream, EPDC_EngineSession engineSession, boolean newLine) {
        super(engineSession);
        try {
            this._logLine = new EExtString(dataInputStream, engineSession);
        }
        catch (IOException e) {
            this._logLine = null;
        }
        this.init(engineSession, newLine);
    }

    private void init(EPDC_EngineSession engineSession, boolean newLine) {
        this._newLine = newLine;
        this._bidiEngine = PDTCorePlugin.getBIDIEngine();
        this._bidi = engineSession.hostBIDIStringsAreInVisualFormat() && this._bidiEngine != null;
    }

    static EStdLogLine createLogLine(DataInputStream dataInputStream, EPDC_EngineSession engineSession) {
        int type;
        boolean newLine = true;
        try {
            dataInputStream.skipBytes(5);
            byte flags = dataInputStream.readByte();
            newLine = (flags & 1) == 0;
            type = dataInputStream.readUnsignedShort();
        }
        catch (IOException e) {
            return null;
        }
        switch (type) {
            case 1: {
                return new EStdCmdLogLine(dataInputStream, engineSession, newLine);
            }
            case 6: {
                return new EStdHiddenCmdLogLine(dataInputStream, engineSession, newLine);
            }
            case 2: {
                return new EStdPgmOutputLine(dataInputStream, engineSession, newLine);
            }
            case 3: {
                return new EStdPgmErrorLine(dataInputStream, engineSession, newLine);
            }
            case 5: {
                return new EStdCmdEchoLine(dataInputStream, engineSession, newLine);
            }
        }
        return null;
    }

    public String getLogLineString() {
        if (this._logLine != null) {
            String line = this._logLine.toString();
            if (this._bidi) {
                line = this._bidiEngine.convertVisualToLogical(line, true);
            }
            if (this.isNewLineRequired() && !line.endsWith("\r")) {
                return line + "\r";
            }
            return line;
        }
        return null;
    }

    private boolean isNewLineRequired() {
        return this._newLine;
    }

    public int getLineType() {
        return this._logLineType;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Line_Type", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Log.*", this._logLineType));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "SuppressNewLine", !this.isNewLineRequired());
    }

    @Override
    int getFixedLen() {
        return 8;
    }

    @Override
    int getVarLen() {
        return EStdLogLine.getTotalBytes(this._logLine);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this._logLineType);
        this._logLine.output(dataOutputStream);
    }
}

