/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdLocalFilter
extends EPDC_Structures {
    private int _filterID;
    private EStdString _filterName;
    private boolean _DefaultState;
    private byte _languageId = 0;
    private static final byte DEFAULT = 1;

    public EStdLocalFilter(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._filterID = dataInputStream.readUnsignedShort();
        this._DefaultState = dataInputStream.readByte() == 1;
        this._languageId = dataInputStream.readByte();
        this._filterName = new EStdString(new OffsetDataInputStream(byteBuffer, dataInputStream.readInt()), engineSession);
        dataInputStream.skipBytes(4);
    }

    public String getLabel() {
        if (this._filterName != null) {
            return this._filterName.toString();
        }
        return "";
    }

    public int getId() {
        return this._filterID;
    }

    public byte getLanguageID() {
        return this._languageId;
    }

    public boolean isDefault() {
        return this._DefaultState;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Filter ID", this._filterID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Filter Name", this._filterName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Filter Default?", this._DefaultState);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Language ID", this._languageId);
    }

    @Override
    public String getDescription() {
        return "Locals filter";
    }
}

