/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdGlobalVariable
extends EPDC_Structures {
    private EStdString _globalName;
    private EStdString _globalExpression;

    public EStdGlobalVariable(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.skipBytes(4);
        int offset = dataInputStream.readInt();
        this._globalName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        offset = dataInputStream.readInt();
        this._globalExpression = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
    }

    public String getGlobalName() {
        if (this._globalName != null) {
            return this._globalName.toString();
        }
        return "";
    }

    public String getGlobalExpression() {
        if (this._globalExpression != null) {
            return this._globalExpression.toString();
        }
        return "";
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Global_Name", this.getGlobalName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Global_Expression", this.getGlobalExpression());
    }

    @Override
    int getFixedLen() {
        return 12;
    }

    @Override
    public String getDescription() {
        return "Global variable";
    }
}

