/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdGlobalSymbol
extends EPDC_Structures {
    private EStdString _symbolName;
    private byte _symbolType;
    private byte _parmsRequired;
    public static final byte POINTER = 1;
    public static final byte POINTERLIST = 2;
    public static final byte XMLSTRING = 3;
    public static final byte PARM_NO = 0;
    public static final byte PARM_YES = 1;

    public EStdGlobalSymbol(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.skipBytes(4);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._symbolName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        dataInputStream.skipBytes(4);
        this._symbolType = dataInputStream.readByte();
        this._parmsRequired = dataInputStream.readByte();
        dataInputStream.skipBytes(2);
    }

    public byte getParmsRequired() {
        return this._parmsRequired;
    }

    public String getSymbolName() {
        if (this._symbolName != null) {
            return this._symbolName.toString();
        }
        return "";
    }

    public byte getSymbolType() {
        return this._symbolType;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "SymbolName", this.getSymbolName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "SymbolType", this.getSymbolType());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ParmsRequired", this.getParmsRequired());
    }

    @Override
    int getFixedLen() {
        return 16;
    }

    @Override
    public String getDescription() {
        return "Global symbol";
    }
}

