/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdFlowPointsHit
extends EPDC_Structures {
    private int[] fFlowPointsHit;

    public EStdFlowPointsHit(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        dis.skipBytes(4);
        int number = dis.readInt();
        this.fFlowPointsHit = new int[number];
        int i = 0;
        while (i < number) {
            this.fFlowPointsHit[i] = dis.readInt();
            ++i;
        }
    }

    public int[] getFlowPointsHit() {
        return this.fFlowPointsHit;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number of Flowpoints", this.fFlowPointsHit.length);
        StringBuilder list = new StringBuilder();
        int[] nArray = this.fFlowPointsHit;
        int n = this.fFlowPointsHit.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            list.append(id).append(",");
            ++n2;
        }
        if (list.length() > 0) {
            list.setLength(list.length() - 1);
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Flow point ids", list.toString());
    }

    @Override
    public String getDescription() {
        return "Flow points hit";
    }
}

