/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdMessage;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdFlowPoint
extends EPDC_Structures {
    private static final byte ENTRY = 1;
    private static final byte PARAGRAPH = 2;
    private static final byte SECTION = 3;
    private static final byte PROGRAM = 4;
    private TYPE fType;
    private int fId;
    private int fFirstLine;
    private int fLastLine;
    private EStdString fSignature;
    private EStdMessage fMessage;

    public EStdFlowPoint(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        switch (dis.readByte()) {
            case 1: {
                this.fType = TYPE.ENTRY;
                break;
            }
            case 2: {
                this.fType = TYPE.PARAGRAPH;
                break;
            }
            case 3: {
                this.fType = TYPE.SECTION;
                break;
            }
            case 4: {
                this.fType = TYPE.PROGRAM;
                break;
            }
            default: {
                this.fType = TYPE.UNKNOWN;
            }
        }
        dis.skipBytes(3);
        this.fId = dis.readInt();
        this.fFirstLine = dis.readInt();
        this.fLastLine = dis.readInt();
        int offset = dis.readInt();
        this.fSignature = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        offset = dis.readInt();
        if (offset != 0) {
            this.fMessage = new EStdMessage(byteBuffer, dis, engineSession);
        }
    }

    public int getId() {
        return this.fId;
    }

    public String getSignature() {
        return this.fSignature.toString();
    }

    public int getFirstLine() {
        return this.fFirstLine;
    }

    public int getLastLine() {
        return this.fLastLine;
    }

    public EStdMessage getMessage() {
        return this.fMessage;
    }

    public TYPE getType() {
        return this.fType;
    }

    public boolean isEntry() {
        return this.fType == TYPE.ENTRY;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, String.format("%s ID=%d First/Last=%d/%d", this.fType.toString(), this.fId, this.fFirstLine, this.fLastLine), this.fSignature);
        if (this.fMessage != null) {
            this.fMessage.writeEPDC(dataOutputStream);
        }
    }

    @Override
    public String getDescription() {
        return "Flow Point";
    }

    public static enum TYPE {
        UNKNOWN,
        ENTRY,
        PARAGRAPH,
        SECTION,
        PROGRAM;

    }
}

