/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdFlowPoint;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class EStdFileFlowPoints
extends EPDC_Structures {
    private int fPartId;
    private int fViewId;
    private int fViewFileId;
    private EStdFlowPoint[] fFlowPoints;

    public EStdFileFlowPoints(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this.fPartId = dis.readInt();
        this.fViewId = dis.readInt();
        this.fViewFileId = dis.readInt();
        int numElements = dis.readInt();
        OffsetDataInputStream ois = new OffsetDataInputStream(byteBuffer, dis.readInt());
        boolean sortRequired = false;
        this.fFlowPoints = new EStdFlowPoint[numElements];
        int i = 0;
        while (i < numElements) {
            this.fFlowPoints[i] = new EStdFlowPoint(byteBuffer, ois, engineSession);
            if (!sortRequired && i > 0 && this.fFlowPoints[i - 1].getFirstLine() > this.fFlowPoints[i].getFirstLine()) {
                sortRequired = true;
            }
            ++i;
        }
        if (sortRequired) {
            Arrays.sort(this.fFlowPoints, new Comparator<EStdFlowPoint>(){

                @Override
                public int compare(EStdFlowPoint o1, EStdFlowPoint o2) {
                    return Integer.compare(o1.getFirstLine(), o2.getFirstLine());
                }
            });
        }
    }

    public int getPartId() {
        return this.fPartId;
    }

    public int getViewId() {
        return this.fViewId;
    }

    public int getViewFileId() {
        return this.fViewFileId;
    }

    public EStdFlowPoint[] getFlowPoints() {
        return this.fFlowPoints;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, String.format("Items[%d] Context P:%d V:%d VF:%d", this.fFlowPoints.length, this.fPartId, this.fViewId, this.fViewFileId));
        EStdFlowPoint[] eStdFlowPointArray = this.fFlowPoints;
        int n = this.fFlowPoints.length;
        int n2 = 0;
        while (n2 < n) {
            EStdFlowPoint element = eStdFlowPointArray[n2];
            element.writeEPDC(dataOutputStream);
            ++n2;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "ViewFile Flow Points";
    }
}

