/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class EStdExpression2
extends EPDC_Structures
implements Serializable {
    private EStdView _context = null;
    private EStdString _exprString = null;
    private int _threadID;
    private int _entryID;
    private static final long serialVersionUID = 20050124L;
    private static final int FIXED_LENGTH = 16;

    EStdExpression2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offsetToContext = dataInputStream.readInt();
        int offsetToString = dataInputStream.readInt();
        this._threadID = dataInputStream.readInt();
        this._entryID = dataInputStream.readInt();
        this._context = new EStdView(new OffsetDataInputStream(byteBuffer, offsetToContext));
        this._exprString = new EStdString(new OffsetDataInputStream(byteBuffer, offsetToString), engineSession);
    }

    public EStdExpression2(EStdView context, String expr, int exprDU, int entryID, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._context = context == null ? new EStdView() : context;
        if (expr != null) {
            this._exprString = new EStdString(expr, engineSession);
        }
        this._threadID = exprDU;
        this._entryID = entryID;
    }

    public EStdView getContext() {
        return this._context;
    }

    public String getExpressionString() {
        if (this._exprString == null) {
            return null;
        }
        return this._exprString.toString();
    }

    public void setEntryID(int id) {
        this._entryID = id;
    }

    @Override
    int getFixedLen() {
        return 16;
    }

    @Override
    int getVarLen() {
        return EStdExpression2.getTotalBytes(this._context) + EStdExpression2.getTotalBytes(this._exprString);
    }

    void output(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        int offset = 16 + baseOffset;
        offset += EStdExpression2.writeOffsetOrZero(dataOutputStream, offset, this._context);
        EStdExpression2.writeOffsetOrZero(dataOutputStream, offset, this._exprString);
        dataOutputStream.writeInt(this._threadID);
        dataOutputStream.writeInt(this._entryID);
        if (this._context != null) {
            this._context.output(dataOutputStream);
        }
        if (this._exprString != null) {
            this._exprString.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this._context != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "StdExpContext" + this._context.getDescription());
            this._context.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "StdExpContext", "NULL");
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "StdExprString", this.getExpressionString());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "StdExpDU", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "StdEntryId", this._entryID);
    }

    @Override
    public String getDescription() {
        return "Conditional expression";
    }
}

