/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EExtString;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdAction;
import com.ibm.debug.pdt.internal.epdc.EStdExprNodeBase;
import com.ibm.debug.pdt.internal.epdc.EStdProperty;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class EStdExprNode
extends EStdExprNodeBase {
    private static final EStdAction[] EMPTYACTIONS = new EStdAction[0];
    private static final EStdProperty[] EMPTYPROPERTIES = new EStdProperty[0];
    private static final byte FORCE_EXPANSION = 1;
    private static final byte READ_ONLY = 2;
    private static final byte REPLACE_NODE = 4;
    private static final byte UPDATE_NODE = 8;
    private static final byte EXTENDED_CHANGE_FLAGS = 16;
    private static final byte UNLIMITED_RANGE = 32;
    private static final byte VALUE_CHANGED = 1;
    private int _index;
    private int _numChildren;
    private int _origNumChildren;
    private String _name;
    private int _offsetValue;
    private String _value;
    private String _type;
    private int _currentRep;
    private int _baseIndex;
    private int _origBaseIndex;
    private int _offsetReps;
    private int _numReps;
    private int[] _representations;
    private static final int[] EMPTYREPS = EMPTYINTARRAY;
    private int _numActions;
    private int _offsetActionList;
    private EStdAction[] _actions;
    private int _numAttributes;
    private int _offsetAttributes;
    private EStdProperty[] _attributes;
    private byte _flags;
    private byte _extChgFlags;
    private int _valueMaxLength;

    public EStdExprNode(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._nodeID = dataInputStream.readInt();
        this._flags = dataInputStream.readByte();
        this._extChgFlags = dataInputStream.readByte();
        dataInputStream.skipBytes(2);
        this._parentID = dataInputStream.readInt();
        this._index = dataInputStream.readInt();
        this._origNumChildren = this._numChildren = dataInputStream.readInt();
        this._origBaseIndex = this._baseIndex = dataInputStream.readInt();
        int offset = 0;
        offset = dataInputStream.readInt();
        this._name = offset != 0 ? new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession).toString() : "";
        this._offsetValue = dataInputStream.readInt();
        this._valueMaxLength = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        this._type = offset != 0 ? new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession).toString() : "";
        this._languageID = dataInputStream.readInt();
        this._typeIndex = dataInputStream.readUnsignedShort();
        this._numReps = dataInputStream.readUnsignedShort();
        this._currentRep = dataInputStream.readUnsignedShort();
        this._offsetReps = dataInputStream.readInt();
        if (this._numReps == 0 || this._offsetReps == 0) {
            this._representations = EMPTYREPS;
        }
        this._numActions = dataInputStream.readUnsignedShort();
        this._offsetActionList = dataInputStream.readInt();
        this._numAttributes = dataInputStream.readUnsignedShort();
        this._offsetAttributes = dataInputStream.readInt();
        dataInputStream.skipBytes(32);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public int getChildNum() {
        return this._index;
    }

    public int[] getReps() {
        if (this._representations == null) {
            OffsetDataInputStream repsStream = new OffsetDataInputStream(this.getByteBuffer(), this._offsetReps);
            this._representations = new int[this._numReps];
            int i = 0;
            while (i < this._representations.length) {
                try {
                    this._representations[i] = repsStream.readUnsignedShort();
                }
                catch (IOException e) {
                    this._representations = EMPTYREPS;
                    break;
                }
                ++i;
            }
            try {
                repsStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Arrays.copyOf(this._representations, this._representations.length);
    }

    /*
     * Unable to fully structure code
     */
    public EStdAction[] getActions() {
        if (this._actions != null) {
            return Arrays.copyOf(this._actions, this._actions.length);
        }
        if (this._offsetActionList == 0) {
            this._actions = EStdExprNode.EMPTYACTIONS;
            return EStdExprNode.EMPTYACTIONS;
        }
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                actionStream = new OffsetDataInputStream(this.getByteBuffer(), this._offsetActionList);
                try {
                    this._actions = new EStdAction[this._numActions];
                    i = 0;
                    while (true) {
                        try {
                            this._actions[i] = new EStdAction(this.getByteBuffer(), actionStream, this.getEPDCEngineSession());
                        }
                        catch (IOException e) {
                            this._actions = EStdExprNode.EMPTYACTIONS;
                            if (actionStream != null) {
                                actionStream.close();
                            }
                            return EStdExprNode.EMPTYACTIONS;
                        }
                        ++i;
                        return i;
                    }
                }
                finally {
                    if (i < this._numActions) ** continue;
                }
            }
            catch (Throwable var2_5) {
                if (var1_1 == null) {
                    var1_1 = var2_5;
                } else if (var1_1 != var2_5) {
                    var1_1.addSuppressed(var2_5);
                }
                throw var1_1;
            }
        }
        catch (IOException var1_3) {
            // empty catch block
        }
        return Arrays.copyOf(this._actions, this._actions.length);
    }

    public int getNumActions() {
        return this._numActions;
    }

    /*
     * Unable to fully structure code
     */
    public EStdProperty[] getAttributes() {
        if (this._attributes != null) {
            return Arrays.copyOf(this._attributes, this._attributes.length);
        }
        if (this._offsetAttributes == 0) {
            this._attributes = EStdExprNode.EMPTYPROPERTIES;
            return EStdExprNode.EMPTYPROPERTIES;
        }
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                attrStream = new OffsetDataInputStream(this.getByteBuffer(), this._offsetAttributes);
                try {
                    this._attributes = new EStdProperty[this._numAttributes];
                    i = 0;
                    while (true) {
                        try {
                            this._attributes[i] = new EStdProperty(this.getByteBuffer(), attrStream, this.getEPDCEngineSession());
                        }
                        catch (IOException e) {
                            this._attributes = EStdExprNode.EMPTYPROPERTIES;
                            if (attrStream != null) {
                                attrStream.close();
                            }
                            return EStdExprNode.EMPTYPROPERTIES;
                        }
                        ++i;
                        return i;
                    }
                }
                finally {
                    if (i < this._numAttributes) ** continue;
                }
            }
            catch (Throwable var2_5) {
                if (var1_1 == null) {
                    var1_1 = var2_5;
                } else if (var1_1 != var2_5) {
                    var1_1.addSuppressed(var2_5);
                }
                throw var1_1;
            }
        }
        catch (IOException var1_3) {
            // empty catch block
        }
        return Arrays.copyOf(this._attributes, this._attributes.length);
    }

    public String getValueString() {
        if (this._value != null) {
            return this._value;
        }
        this._value = "";
        if (this._offsetValue != 0) {
            try {
                this._value = new EExtString(new OffsetDataInputStream(this.getByteBuffer(), this._offsetValue), this.getEPDCEngineSession()).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this._value;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        int n;
        EPDC_DumpUtils.NameVal[] flagConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "FORCE_EXPANSION"), new EPDC_DumpUtils.NameVal(2, "READ_ONLY"), new EPDC_DumpUtils.NameVal(4, "REPLACE_NODE"), new EPDC_DumpUtils.NameVal(8, "UPDATE_NODE"), new EPDC_DumpUtils.NameVal(16, "EXTENDED_CHANGE_FLAGS"), new EPDC_DumpUtils.NameVal(32, "UNLIMITED_RANGE")};
        EPDC_DumpUtils.NameVal[] extChgFlagConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "VALUE_CHANGED")};
        EPDC_EngineSession engineSession = this.getEPDCEngineSession();
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NodeID", this.getId());
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Flags", this._flags, flagConstants);
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Extended Change Flags", this._extChgFlags, extChgFlagConstants);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ParentNode", this.getParentID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NodeIndex", this._index);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumChildren", this.getNumChildren());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "BaseIndex", this.getBaseIndex());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NodeName", this.getName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NodeValue", this.getValueString());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ValueLength", this._valueMaxLength);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NodeType", this.getType());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "LangID", this._languageID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "RepType", this._typeIndex);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumReps", this.getReps().length);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "CurrentRep", this.getCurrentRep());
        if (this.getReps().length > 0) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "AvailableReps");
            n = 0;
            while (n < this.getReps().length) {
                int rep = this.getReps()[n];
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + n + "]", rep + " (" + engineSession.getRepNames()[this.getReps()[n]] + ")");
                ++n;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumActions", this._numActions);
        if (this._numActions > 0) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Actions");
            n = 0;
            while (n < this.getActions().length) {
                this.getActions()[n].writeEPDC(dataOutputStream);
                ++n;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumProperties", this._numAttributes);
        if (this._numAttributes > 0) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Properties");
            n = 0;
            while (n < this.getAttributes().length) {
                this.getAttributes()[n].writeEPDC(dataOutputStream);
                ++n;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }

    public boolean isNodeReplaced() {
        return (this._flags & 4) != 0;
    }

    public boolean isNodeUpdated() {
        return (this._flags & 8) != 0;
    }

    @Override
    public boolean isReadOnly() {
        return (this._flags & 2) != 0;
    }

    public boolean isUnlimitedRange() {
        return (this._flags & 0x20) != 0;
    }

    @Override
    public int getNumChildren() {
        return this._numChildren;
    }

    public int getOrigNumChildren() {
        return this._origNumChildren;
    }

    @Override
    public boolean hasChildren() {
        return this._numChildren > 0;
    }

    public int getCurrentRep() {
        return this._currentRep;
    }

    @Override
    public int getBaseIndex() {
        return this._baseIndex;
    }

    public int getOrigBaseIndex() {
        return this._origBaseIndex;
    }

    public void setIndexRange(int baseIndex, int numChildren) {
        this._baseIndex = baseIndex;
        this._numChildren = numChildren;
        if (this._numChildren < 0) {
            this._numChildren = 0;
        }
        if (!this.isUnlimitedRange()) {
            if (this._baseIndex < this._origBaseIndex || this._baseIndex >= this._origBaseIndex + this._origNumChildren) {
                this._numChildren -= this._origBaseIndex - this._baseIndex;
                this._baseIndex = this._origBaseIndex;
            }
            if (this._baseIndex + this._numChildren > this._origBaseIndex + this._origNumChildren) {
                this._numChildren = this._origNumChildren - (this._baseIndex - this._origBaseIndex);
            }
        }
    }

    @Override
    public boolean isValueChanged() {
        if ((this._flags & 0x10) != 0) {
            return (this._extChgFlags & 1) != 0;
        }
        return this.isNodeUpdated();
    }

    @Override
    public String getDescription() {
        return "Expression Node (310+)";
    }

    public int getValueMaxLength() {
        return this._valueMaxLength;
    }
}

