/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdEventBPData;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;

public class EStdEnhancedWatchBPData
extends EStdEventBPData {
    private static final long serialVersionUID = 20090720L;
    private static final int VERSION = 1;
    private EStdString fAddrOrExpr = null;
    private EStdView fContext = EStdView.EMPTY_VIEW;
    private int fByteCount = 0;
    private EStdString fRegister = null;
    private EStdString fMatchContents = null;
    private EStdString fMatchModuleName = null;
    private EStdString fMatchPartName = null;
    private EStdString fFromAddrRange = null;
    private EStdString fToAddrRange = null;
    private EStdExpression2 fConditionalExpr = null;
    private EStdString fRestoreAddress = null;
    private EStdString fAction = null;

    public EStdEnhancedWatchBPData(String addrOrExpr, int byteCount, EStdView context, EPDC_EngineSession engineSession) {
        super(engineSession);
        this.fAddrOrExpr = new EStdString(addrOrExpr, engineSession);
        this.fByteCount = byteCount;
        this.fContext = context;
    }

    EStdEnhancedWatchBPData(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.readByte();
        dataInputStream.skipBytes(7);
        this.fByteCount = dataInputStream.readInt();
        this.fContext = new EStdView(dataInputStream);
        dataInputStream.skipBytes(8);
        int offset = 0;
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this.fAddrOrExpr = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fRegister = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fMatchContents = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fMatchModuleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fMatchPartName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fFromAddrRange = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fToAddrRange = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fRestoreAddress = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public String getBreakpointExpression() {
        String bpexpr = EStdString.toString(this.fAddrOrExpr);
        if (!PDTCoreUtils.isEmpty(bpexpr)) {
            return bpexpr;
        }
        bpexpr = EStdString.toString(this.fRegister);
        if (!PDTCoreUtils.isEmpty(bpexpr)) {
            return NLS.bind((String)PICLLabels.picl_watch_BP_register_expression, (Object)bpexpr);
        }
        return "";
    }

    public EStdString getAddrOrExpr() {
        return this.fAddrOrExpr;
    }

    public int getByteCount() {
        return this.fByteCount;
    }

    public void setRegister(String register) {
        this.fRegister = this.getNewEStdStringOrNull(register);
    }

    private EStdString getNewEStdStringOrNull(String str) {
        return str == null ? null : new EStdString(str, this.getEPDCEngineSession());
    }

    public EStdString getRegister() {
        return this.fRegister;
    }

    public void setMatchContents(String matchContents) {
        this.fMatchContents = this.getNewEStdStringOrNull(matchContents);
    }

    public EStdString getMatchContents() {
        return this.fMatchContents;
    }

    public void setMatchPartName(String matchPartName) {
        this.fMatchPartName = this.getNewEStdStringOrNull(matchPartName);
    }

    public EStdString getMatchPartName() {
        return this.fMatchPartName;
    }

    public void setMatchModuleName(String matchModuleName) {
        this.fMatchModuleName = this.getNewEStdStringOrNull(matchModuleName);
    }

    public EStdString getMatchModuleName() {
        return this.fMatchModuleName;
    }

    public void setFromAddrRange(String fromAddrRange) {
        this.fFromAddrRange = this.getNewEStdStringOrNull(fromAddrRange);
    }

    public EStdString getFromAddrRange() {
        return this.fFromAddrRange;
    }

    public void setToAddrRange(String toAddrRange) {
        this.fToAddrRange = this.getNewEStdStringOrNull(toAddrRange);
    }

    public EStdString getToAddrRange() {
        return this.fToAddrRange;
    }

    public void setAction(String action) {
        this.fAction = this.getNewEStdStringOrNull(action);
    }

    public EStdString getAction() {
        return this.fAction;
    }

    public void setConditionalExpr(EStdExpression2 conditionalExpr) {
        this.fConditionalExpr = conditionalExpr;
    }

    public EStdExpression2 getConditionalExpr() {
        return this.fConditionalExpr;
    }

    public void setRestoreAddress(String restoreAddress) {
        this.fRestoreAddress = this.getNewEStdStringOrNull(restoreAddress);
    }

    public EStdString getRestoreAddress() {
        return this.fRestoreAddress;
    }

    public EStdView getContext() {
        return this.fContext;
    }

    @Override
    void output(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        dataOutputStream.writeByte(1);
        dataOutputStream.write(new byte[3]);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.fByteCount);
        this.fContext.output(dataOutputStream);
        dataOutputStream.write(new byte[8]);
        int offset = this.getFixedLen() + baseOffset;
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fAddrOrExpr);
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fRegister);
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fMatchContents);
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fMatchModuleName);
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fMatchPartName);
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fFromAddrRange);
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fToAddrRange);
        offset += EStdEnhancedWatchBPData.writeOffsetOrZero(dataOutputStream, offset, this.fRestoreAddress);
        dataOutputStream.write(new byte[16]);
        if (this.fAddrOrExpr != null) {
            this.fAddrOrExpr.output(dataOutputStream);
        }
        if (this.fRegister != null) {
            this.fRegister.output(dataOutputStream);
        }
        if (this.fMatchContents != null) {
            this.fMatchContents.output(dataOutputStream);
        }
        if (this.fMatchModuleName != null) {
            this.fMatchModuleName.output(dataOutputStream);
        }
        if (this.fMatchPartName != null) {
            this.fMatchPartName.output(dataOutputStream);
        }
        if (this.fFromAddrRange != null) {
            this.fFromAddrRange.output(dataOutputStream);
        }
        if (this.fToAddrRange != null) {
            this.fToAddrRange.output(dataOutputStream);
        }
        if (this.fRestoreAddress != null) {
            this.fRestoreAddress.output(dataOutputStream);
        }
    }

    @Override
    int getVarLen() {
        return EStdEnhancedWatchBPData.getTotalBytes(this.fAddrOrExpr) + EStdEnhancedWatchBPData.getTotalBytes(this.fRegister) + EStdEnhancedWatchBPData.getTotalBytes(this.fMatchContents) + EStdEnhancedWatchBPData.getTotalBytes(this.fMatchModuleName) + EStdEnhancedWatchBPData.getTotalBytes(this.fMatchPartName) + EStdEnhancedWatchBPData.getTotalBytes(this.fFromAddrRange) + EStdEnhancedWatchBPData.getTotalBytes(this.fToAddrRange) + EStdEnhancedWatchBPData.getTotalBytes(this.fRestoreAddress);
    }

    @Override
    int getFixedLen() {
        return 80;
    }

    @Override
    int getTotalBytes() {
        return this.getFixedLen() + this.getVarLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "byteCount", this.fByteCount);
        if (this.fConditionalExpr != null) {
            this.fConditionalExpr.writeEPDC(dataOutputStream);
        }
        if (this.fContext != null) {
            this.fContext.writeEPDC(dataOutputStream);
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "AddrOrExpr", this.fAddrOrExpr);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Register", this.fRegister);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MatchContents", this.fMatchContents);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MatchModuleName", this.fMatchModuleName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "MatchPartName", this.fMatchPartName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "FromAddrRange", this.fFromAddrRange);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ToAddrRange", this.fToAddrRange);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "RestoreAddress", this.fRestoreAddress);
    }

    @Override
    public String getDescription() {
        return "Enhanced Watch BP data";
    }
}

