/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class EStdBranchPointsHit
extends EPDC_Structures {
    private int[] fTargetBranchPointsHit;
    private int fID;

    public EStdBranchPointsHit(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this.fID = dis.readInt();
        int number = dis.readInt();
        this.fTargetBranchPointsHit = new int[number];
        int i = 0;
        while (i < number) {
            this.fTargetBranchPointsHit[i] = dis.readInt();
            ++i;
        }
    }

    public int[] getFlowPointsHit() {
        return Arrays.copyOf(this.fTargetBranchPointsHit, this.fTargetBranchPointsHit.length);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Source Branch ID", this.fID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number of Flowpoints", this.fTargetBranchPointsHit.length);
        StringBuilder list = new StringBuilder();
        int[] nArray = this.fTargetBranchPointsHit;
        int n = this.fTargetBranchPointsHit.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            list.append(id).append(",");
            ++n2;
        }
        if (list.length() > 0) {
            list.setLength(list.length() - 1);
        }
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Branch point ids", list.toString());
    }

    @Override
    public String getDescription() {
        return "Branch points hit";
    }

    public int getSourceBranchPointID() {
        return this.fID;
    }

    public int[] getTargetBranchPointsHit() {
        return Arrays.copyOf(this.fTargetBranchPointsHit, this.fTargetBranchPointsHit.length);
    }
}

