/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdSourceBranchPoint;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class EStdBranchPoints
extends EPDC_Structures {
    private int fPartId;
    private int fViewId;
    private int fViewFileId;
    private EStdSourceBranchPoint[] fBranchPoints;

    public EStdBranchPoints(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(engineSession);
        this.fPartId = dis.readInt();
        this.fViewId = dis.readInt();
        this.fViewFileId = dis.readInt();
        int numElements = dis.readInt();
        OffsetDataInputStream ois = new OffsetDataInputStream(byteBuffer, dis.readInt());
        this.fBranchPoints = new EStdSourceBranchPoint[numElements];
        int i = 0;
        while (i < numElements) {
            this.fBranchPoints[i] = new EStdSourceBranchPoint(byteBuffer, ois, engineSession);
            ++i;
        }
        ois.close();
    }

    public int getPartId() {
        return this.fPartId;
    }

    public int getViewId() {
        return this.fViewId;
    }

    public int getViewFileId() {
        return this.fViewFileId;
    }

    public EStdSourceBranchPoint[] getSourceBranchPoints() {
        return Arrays.copyOf(this.fBranchPoints, this.fBranchPoints.length);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, String.format("Items[%d] Context P:%d V:%d VF:%d", this.fBranchPoints.length, this.fPartId, this.fViewId, this.fViewFileId));
        EStdSourceBranchPoint[] eStdSourceBranchPointArray = this.fBranchPoints;
        int n = this.fBranchPoints.length;
        int n2 = 0;
        while (n2 < n) {
            EStdSourceBranchPoint element = eStdSourceBranchPointArray[n2];
            element.writeEPDC(dataOutputStream);
            ++n2;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Branch Points";
    }
}

