/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdNameValuePair2;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdAttribute
extends EPDC_Structures {
    private byte _attributeType;
    private EStdNameValuePair2 _attributeNameValue;
    private static final int FIXED_LENGTH = 4;

    public EStdAttribute(byte attributeType, String attributeName, String attributeValue, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._attributeType = attributeType;
        this._attributeNameValue = new EStdNameValuePair2(attributeName, attributeValue, engineSession);
    }

    EStdAttribute(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._attributeType = dataInputStream.readByte();
        dataInputStream.skipBytes(3);
        this._attributeNameValue = new EStdNameValuePair2(byteBuffer, dataInputStream, engineSession);
    }

    @Override
    int getFixedLen() {
        return 4 + this._attributeNameValue.getFixedLen();
    }

    @Override
    int getVarLen() {
        return this._attributeNameValue.getVarLen();
    }

    public byte getType() {
        return this._attributeType;
    }

    public String getName() {
        return this._attributeNameValue.getName();
    }

    public String getValue() {
        return this._attributeNameValue.getValue();
    }

    void setName(String newName) {
        this._attributeNameValue.setName(newName);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] attConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(0, "ThreadMiscAttr"), new EPDC_DumpUtils.NameVal(1, "ThreadNameOrTID"), new EPDC_DumpUtils.NameVal(2, "ThreadState"), new EPDC_DumpUtils.NameVal(3, "ThreadPriority"), new EPDC_DumpUtils.NameVal(4, "ThreadGroup"), new EPDC_DumpUtils.NameVal(5, "ThreadBlockingThread")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Attribute_Type", EPDC_DumpUtils.getAttrbuteName(attConstants, this.getType()));
        if (this._attributeNameValue != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Name_Value_Of_Attribute");
            this._attributeNameValue.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Name_Value_Of_Attribute", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Attribute";
    }
}

