/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdGenericNode;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@Deprecated
public class EStdArrayItem
extends EStdGenericNode {
    private int _numElements;
    private int _baseIndex;
    private EStdString _arrayName;
    private EStdString _arrayType;
    private int _currentRepIndex;
    private int[] _arrayReps;

    public EStdArrayItem(byte[] byteBuffer, DataInputStream dataInputStream, int nodeType, EPDC_EngineSession engineSession) throws IOException {
        super(nodeType, engineSession);
        dataInputStream.skipBytes(2);
        this._numElements = dataInputStream.readInt();
        this._numElements = this._numElements > 65535 ? 65535 : this._numElements;
        this._baseIndex = dataInputStream.readInt();
        dataInputStream.skipBytes(8);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._arrayName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._arrayType = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        dataInputStream.skipBytes(4);
        this._currentRepIndex = dataInputStream.readUnsignedShort();
        int numReps = dataInputStream.readUnsignedShort();
        this._arrayReps = new int[numReps];
        int i = 0;
        while (i < numReps) {
            this._arrayReps[i] = dataInputStream.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public String getName() {
        if (this._arrayName != null) {
            return this._arrayName.toString();
        }
        return "";
    }

    @Override
    public String getType() {
        if (this._arrayType != null) {
            return this._arrayType.toString();
        }
        return "";
    }

    public int getItemCount() {
        return this._numElements;
    }

    public int getCurrentRep() {
        return this._currentRepIndex;
    }

    public int[] getArrayOfReps() {
        return this._arrayReps;
    }

    @Override
    public int getBaseIndex() {
        return this._baseIndex;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Element", this.getItemCount());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Base_Index", this.getBaseIndex());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Array_Name", this.getName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Array_Type", this.getType());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Current_Representation_Index", this.getCurrentRep());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Allowed_Representations", this._arrayReps.length);
        if (this._arrayReps.length == 0) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Array_Representations");
            int i = 0;
            while (i < this._arrayReps.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._arrayReps[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Array_Representations", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Array item";
    }
}

