/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdAction
extends EPDC_Structures {
    private static final byte DISABLED = 1;
    private byte _flags;
    private int _labelIdx;
    private int _actionID;

    public EStdAction(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._flags = dataInputStream.readByte();
        dataInputStream.skipBytes(3);
        this._labelIdx = dataInputStream.readUnsignedShort();
        this._actionID = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(4);
    }

    public int getLabelIdx() {
        return this._labelIdx;
    }

    public int getId() {
        return this._actionID;
    }

    public boolean isEnabled() {
        return (this._flags & 1) == 0;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] flagConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "DISABLED")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Flags", this._flags, flagConstants);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "LabelIdx", this.getLabelIdx());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ActionID", this.getId());
    }

    @Override
    public String getDescription() {
        return "Action";
    }
}

