/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqViewsVerify
extends EPDC_Request {
    private int _partID;
    private int _srcFileIndex;
    private static final int FIXED_LENGTH = 6;

    public EReqViewsVerify(int partID, int fileIndex, EPDC_EngineSession engineSession) {
        super(28, engineSession);
        this._partID = partID;
        this._srcFileIndex = fileIndex;
    }

    EReqViewsVerify(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._partID = dataInputStream.readUnsignedShort();
        this._srcFileIndex = dataInputStream.readInt();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._partID);
        dataOutputStream.writeInt(this._srcFileIndex);
    }

    public int getPartId() {
        return this._partID;
    }

    public int getSrcFileIndex() {
        return this._srcFileIndex;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_ID", this.getPartId());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Source_File_Index", this.getSrcFileIndex());
    }

    @Override
    int getFixedLen() {
        return 6 + super.getFixedLen();
    }

    @Override
    public String getDescription() {
        return "Verify view";
    }
}

