/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqViewSearchPath
extends EPDC_Request {
    private int _partId;
    private int _viewNum;
    private int _srcFileIndex;
    private static final int FIXED_LENGTH = 8;

    EReqViewSearchPath(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._partId = dataInputStream.readUnsignedShort();
        this._viewNum = dataInputStream.readUnsignedShort();
        this._srcFileIndex = dataInputStream.readInt();
    }

    public EReqViewSearchPath(int partId, int viewNum, int srcFileIndex, EPDC_EngineSession engineSession) {
        super(227, engineSession);
        this._partId = partId;
        this._viewNum = viewNum;
        this._srcFileIndex = srcFileIndex;
    }

    @Override
    int getFixedLen() {
        return 8 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._partId);
        dataOutputStream.writeShort(this._viewNum);
        dataOutputStream.writeInt(this._srcFileIndex);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_ID", this._partId);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Number", this._viewNum);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Src_File_Index", this._srcFileIndex);
    }

    @Override
    public String getDescription() {
        return "Get view search paths";
    }
}

