/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EViewFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqViewFileInfoSet
extends EPDC_Request {
    int _partID;
    int _viewNum;
    int _srcFileIndex;
    EViewFile _eview;
    private static final int FIXED_LENGTH = 8;

    public EReqViewFileInfoSet(int partID, int viewNum, short srcFileIndex, EViewFile eview, EPDC_EngineSession engineSession) {
        super(226, engineSession);
        this._partID = partID;
        this._viewNum = viewNum;
        this._srcFileIndex = srcFileIndex;
        this._eview = eview;
    }

    EReqViewFileInfoSet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._partID = dataInputStream.readUnsignedShort();
        this._viewNum = dataInputStream.readUnsignedShort();
        this._srcFileIndex = dataInputStream.readInt();
        this._eview = new EViewFile(byteBuffer, dataInputStream, engineSession);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._partID);
        dataOutputStream.writeShort(this._viewNum);
        dataOutputStream.writeInt(this._srcFileIndex);
        this._eview.output(dataOutputStream, this.getFixedLen() + super.getVarLen());
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_ID", this._partID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Num", this._viewNum);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Src_File_Index", this._srcFileIndex);
        if (this._eview != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Views_Information");
            this._eview.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Views_Information", "NULL");
        }
    }

    @Override
    int getFixedLen() {
        return 8 + this._eview.getFixedLen() + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + this._eview.getVarLen();
    }

    @Override
    public String getDescription() {
        return "Set view file info";
    }
}

