/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EReqVersion;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqVersionSecure
extends EReqVersion {
    private EStdString fUserId;
    private EStdString fPassword;

    public EReqVersionSecure(int uiVersion, String userId, char[] password, EPDC_EngineSession engineSession) {
        super(uiVersion, engineSession);
        this._request_code = 79;
        assert (userId != null && password != null);
        this.fUserId = new EStdString(userId, engineSession);
        this.fPassword = new EStdString(password, engineSession);
    }

    public EReqVersionSecure(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this.fUserId = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fPassword = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    String getUserId() {
        return this.fUserId.toString();
    }

    String getPassword() {
        return this.fPassword.toString();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        offset += EReqVersionSecure.writeOffsetOrZero(dataOutputStream, offset, this.fUserId);
        EReqVersionSecure.writeOffsetOrZero(dataOutputStream, offset, this.fPassword);
        this.fUserId.output(dataOutputStream);
        this.fPassword.output(dataOutputStream);
    }

    @Override
    int getFixedLen() {
        return 20;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqVersionSecure.getTotalBytes(this.fUserId) + EReqVersionSecure.getTotalBytes(this.fPassword);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        super.writeEPDC(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "User ID", this.fUserId);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Password", this.fPassword);
    }

    @Override
    public String getDescription() {
        return "EPDC secure version";
    }
}

