/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqVersion
extends EPDC_Request {
    private int _front_end_version;

    public EReqVersion(int uiVersion, EPDC_EngineSession engineSession) {
        super(66, engineSession);
        this._front_end_version = uiVersion;
    }

    public EReqVersion(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._request_code = dataInputStream.readInt();
        this.setTotalBytes(dataInputStream.readInt());
        this._front_end_version = dataInputStream.readInt();
    }

    public int getVersion() {
        return this._front_end_version;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this._request_code);
        dataOutputStream.writeInt(this.getFixedLen());
        dataOutputStream.writeInt(this._front_end_version);
    }

    @Override
    int getFixedLen() {
        return 12;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "UI EPDC version", this._front_end_version);
    }

    @Override
    public String getDescription() {
        return "EPDC version";
    }
}

