/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqTerminatePgm
extends EPDC_Request {
    private byte _terminateType = 0;
    private static final int TERMINATE_LEN = 8;

    public EReqTerminatePgm(byte terminateType, EPDC_EngineSession engineSession) {
        super(25, engineSession);
        this._terminateType = terminateType;
    }

    EReqTerminatePgm(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        if (this.getEPDCEngineSession().supportsTerminateType()) {
            this._terminateType = dataInputStream.readByte();
            dataInputStream.skipBytes(5);
        }
    }

    public byte getTerminateType() {
        return this._terminateType;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        if (this.getEPDCEngineSession().supportsTerminateType()) {
            dataOutputStream.writeByte(this._terminateType);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeInt(0);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] constants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(0, "TerminateDefault"), new EPDC_DumpUtils.NameVal(1, "TerminateDetach"), new EPDC_DumpUtils.NameVal(2, "TerminateAbend")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Terminate_Type", EPDC_DumpUtils.getAttrbuteName(constants, this.getTerminateType()));
    }

    @Override
    int getFixedLen() {
        int len = super.getFixedLen();
        if (this.getEPDCEngineSession().supportsTerminateType()) {
            len += 8;
        }
        return len;
    }

    @Override
    public String getDescription() {
        return "Terminate program";
    }
}

