/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqStringFind
extends EPDC_Request {
    private EStdView _findContext;
    private int _searchStringOffset;
    private EStdString _searchString;
    private int _numLinesToSearch;
    private int _startColumnNum;
    private int _searchFlags;
    private static final int CaseSensitive = Integer.MIN_VALUE;
    private static final int FIXED_LENGTH = 28;

    public EReqStringFind(EStdView startingLocation, String string, int numLinesToSearch, int startingColumn, boolean caseSensitive, EPDC_EngineSession engineSession) {
        super(24, engineSession);
        this._findContext = startingLocation;
        this._searchString = new EStdString(string, engineSession);
        this._numLinesToSearch = numLinesToSearch;
        this._startColumnNum = startingColumn;
        if (caseSensitive) {
            this._searchFlags = Integer.MIN_VALUE;
        }
    }

    EReqStringFind(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._findContext = new EStdView(dataInputStream);
        this._searchStringOffset = dataInputStream.readInt();
        if (this._searchStringOffset != 0) {
            this._searchString = new EStdString(new OffsetDataInputStream(byteBuffer, this._searchStringOffset), engineSession);
        }
        this._numLinesToSearch = dataInputStream.readInt();
        this._startColumnNum = dataInputStream.readInt();
        this._searchFlags = dataInputStream.readInt();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        this._findContext.output(dataOutputStream);
        EReqStringFind.writeOffsetOrZero(dataOutputStream, this.getFixedLen() + super.getVarLen(), this._searchString);
        dataOutputStream.writeInt(this._numLinesToSearch);
        dataOutputStream.writeInt(this._startColumnNum);
        dataOutputStream.writeInt(this._searchFlags);
        if (this._searchString != null) {
            this._searchString.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Search_String", this._searchString.toString());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Lines_To_Search", this._numLinesToSearch);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Start_Column_Number", this._startColumnNum);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Search_Flag", this._searchFlags);
        if (this._findContext != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Find_Context");
            this._findContext.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Find_Context", "NULL");
        }
    }

    @Override
    int getFixedLen() {
        return 28 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqStringFind.getTotalBytes(this._searchString);
    }

    @Override
    public String getDescription() {
        return "Find string";
    }
}

