/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqStorageUsageCheckSet
extends EPDC_Request {
    private int _storageUsageCheckAttribute;
    private static final int FIXED_LENGTH = 4;

    public EReqStorageUsageCheckSet(int attribute, EPDC_EngineSession engineSession) {
        super(214, engineSession);
        this._storageUsageCheckAttribute = attribute;
    }

    public EReqStorageUsageCheckSet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._storageUsageCheckAttribute = dataInputStream.readInt();
    }

    @Override
    int getFixedLen() {
        return 4 + super.getFixedLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._storageUsageCheckAttribute);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] constants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "StorageUsageCheckEnable"), new EPDC_DumpUtils.NameVal(0x40000000, "DebuggerBusyBoxEnable"), new EPDC_DumpUtils.NameVal(0x20000000, "AutoSetEntryBkpEnable"), new EPDC_DumpUtils.NameVal(0x10000000, "RunMinimizedEnable"), new EPDC_DumpUtils.NameVal(0x8000000, "DateBkpEnable")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Storage_Usage_CheckAttr", this._storageUsageCheckAttribute, constants);
    }

    @Override
    public String getDescription() {
        return "Set storage usage check";
    }
}

