/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdStorageLocation;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@Deprecated
public class EReqStorageUpdate
extends EPDC_Request {
    private int _id;
    private EStdStorageLocation _location;
    private int _unitFieldIndex;
    private int _numberOfUnits;
    private EStdString _value;
    private static final int FIXED_LENGTH = 26;

    public EReqStorageUpdate(int id, String address, int lineOffset, int columnOffset, int unitFieldIndex, int numberOfUnits, String value, EPDC_EngineSession engineSession) {
        super(23, engineSession);
        this._id = id;
        this._location = new EStdStorageLocation(address, lineOffset, columnOffset, engineSession);
        this._unitFieldIndex = unitFieldIndex;
        this._numberOfUnits = numberOfUnits;
        this._value = new EStdString(value, engineSession);
    }

    EReqStorageUpdate(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._id = dataInputStream.readUnsignedShort();
        this._location = new EStdStorageLocation(byteBuffer, dataInputStream, engineSession);
        this._unitFieldIndex = dataInputStream.readInt();
        this._numberOfUnits = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._value = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._id);
        int locationOffset = this.getFixedLen() + super.getVarLen();
        this._location.outputFixedPart(dataOutputStream, locationOffset);
        dataOutputStream.writeInt(this._unitFieldIndex);
        dataOutputStream.writeInt(this._numberOfUnits);
        EReqStorageUpdate.writeOffsetOrZero(dataOutputStream, locationOffset + this._location.getVarLen(), this._value);
        this._location.outputVariablePart(dataOutputStream);
        this._value.output(dataOutputStream);
    }

    @Override
    int getFixedLen() {
        return 26 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + this._location.getVarLen() + EReqStorageUpdate.getTotalBytes(this._value);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_ID_To_Change", this._id);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Unit_To_Change", this._unitFieldIndex);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "NumUnits_To_Update", this._numberOfUnits);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "New_Unit_Contents", this._value);
        if (this._location != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Start_Of_Changed_Storage");
            this._location.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Start_Of_Changed_Storage", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Storage update (<310)";
    }
}

