/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqStoragePutBlock
extends EPDC_Request {
    private EStdString _address;
    private byte[] _storage;

    public EReqStoragePutBlock(String address, byte[] storage, EPDC_EngineSession engineSession) {
        super(72, engineSession);
        this._address = new EStdString(address, engineSession);
        this._storage = storage;
    }

    public EReqStoragePutBlock(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._address = new EStdString(new OffsetDataInputStream(byteBuffer, dataInputStream.readInt()), engineSession);
        int blockSize = dataInputStream.readInt();
        OffsetDataInputStream ois = new OffsetDataInputStream(byteBuffer, dataInputStream.readInt());
        this._storage = new byte[blockSize];
        ois.read(this._storage);
        ois.close();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        offset += EReqStoragePutBlock.writeOffsetOrZero(dataOutputStream, offset, this._address);
        dataOutputStream.writeInt(this._storage.length);
        dataOutputStream.writeInt(offset);
        dataOutputStream.write(new byte[20]);
        this._address.output(dataOutputStream);
        dataOutputStream.write(this._storage);
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 32;
    }

    @Override
    int getVarLen() {
        return this._address.getTotalBytes() + this._storage.length + super.getVarLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "address", this._address);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "# of bytes", this._storage.length);
        EPDC_DumpUtils.writeBytes(dataOutputStream, "content", this._storage, 0);
    }

    @Override
    public String getDescription() {
        return "Write storage";
    }
}

