/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqStorageGetBlock
extends EPDC_Request {
    private EStdString _address;
    private int _blockSize;

    public EReqStorageGetBlock(String address, int blockSize, EPDC_EngineSession engineSession) {
        super(71, engineSession);
        this._address = new EStdString(address, engineSession);
        this._blockSize = blockSize;
    }

    public EReqStorageGetBlock(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int addressOffset = dataInputStream.readInt();
        this._address = new EStdString(new OffsetDataInputStream(byteBuffer, addressOffset), engineSession);
        this._blockSize = dataInputStream.readInt();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        EReqStorageGetBlock.writeOffsetOrZero(dataOutputStream, offset, this._address);
        dataOutputStream.writeInt(this._blockSize);
        dataOutputStream.write(new byte[32]);
        if (this._address != null) {
            this._address.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        return 40 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return this._address.getTotalBytes() + super.getVarLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Address", this._address);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Block Size", this._blockSize);
    }

    @Override
    public String getDescription() {
        return "Read storage";
    }
}

