/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdStorageRange;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@Deprecated
public class EReqStorage2
extends EPDC_Request {
    private EStdStorageRange _range;
    private short _addressStyle;
    private short _unitStyle;
    private int _styleUnitCount;
    private int _attributes;
    private EStdExpression2 _addressExpression;
    private static final int FIXED_LENGTH = 24;

    public EReqStorage2(EStdExpression2 expr, int offsetToFirstLine, int offsetToLastLine, short storageUnitSizeTypeAndStyle, int numberOfUnitsPerLine, boolean enableStorage, boolean enableExpression, EPDC_EngineSession engineSession) {
        super(18, engineSession);
        this._addressExpression = expr;
        this._range = new EStdStorageRange(offsetToFirstLine, offsetToLastLine);
        this._addressStyle = 1;
        this._unitStyle = storageUnitSizeTypeAndStyle;
        this._styleUnitCount = numberOfUnitsPerLine;
        if (enableStorage) {
            this._attributes = Integer.MIN_VALUE;
        }
        if (enableExpression) {
            this._attributes |= 0x40000000;
        }
    }

    EReqStorage2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._range = new EStdStorageRange(dataInputStream);
        this._addressStyle = dataInputStream.readShort();
        this._unitStyle = dataInputStream.readShort();
        this._styleUnitCount = dataInputStream.readInt();
        this._attributes = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._addressExpression = new EStdExpression2(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        this._range.output(dataOutputStream);
        dataOutputStream.writeShort(this._addressStyle);
        dataOutputStream.writeShort(this._unitStyle);
        dataOutputStream.writeInt(this._styleUnitCount);
        dataOutputStream.writeInt(this._attributes);
        int offset = this.getFixedLen() + super.getVarLen();
        EReqStorage2.writeOffsetOrZero(dataOutputStream, offset, this._addressExpression);
        if (this._addressExpression != null) {
            this._addressExpression.output(dataOutputStream, offset);
        }
    }

    @Override
    int getFixedLen() {
        return 24 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqStorage2.getTotalBytes(this._addressExpression);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] attConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "StorageEnabled"), new EPDC_DumpUtils.NameVal(0x40000000, "StorageExpreEnabled")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Address_Style", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "StorageAddrStyle.*", this._addressStyle));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Unit_Style", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "StorageStyle.*", this._unitStyle));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Style_Unit_Count", this._styleUnitCount);
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Storage_Attribute", this._attributes, attConstants);
        if (this._addressExpression != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Storage_Expression");
            this._addressExpression.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Expression", "NULL");
        }
        if (this._range != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Storage_Range");
            this._range.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Storage_Range", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "(Deprecated) Monitor storage (<310)";
    }
}

