/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqStartTrace2
extends EPDC_Request {
    private static final byte SAVE_SOURCE_FLAG = 1;
    private byte fFlags;
    private int fLineSeparatorOffset;
    private EStdString fLineSeparator;

    public EReqStartTrace2(boolean saveSource, String lineSeparator, EPDC_EngineSession engineSession) {
        super(242, engineSession);
        if (saveSource) {
            this.fFlags = 1;
        }
        this.fLineSeparator = new EStdString(lineSeparator, engineSession);
    }

    EReqStartTrace2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fFlags = dataInputStream.readByte();
        if (dataInputStream.skipBytes(3) != 3) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in EReqStartTrace2.", 2);
        }
        if ((this.fLineSeparatorOffset = dataInputStream.readInt()) != 0) {
            this.fLineSeparator = new EStdString(new OffsetDataInputStream(byteBuffer, this.fLineSeparatorOffset), engineSession);
        }
        if (dataInputStream.skipBytes(16) != 16) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in EReqStartTrace2.", 2);
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeByte(this.fFlags);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        int offset = this.getFixedLen() + super.getVarLen();
        EReqStartTrace2.writeOffsetOrZero(dataOutputStream, offset, this.fLineSeparator);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        this.fLineSeparator.output(dataOutputStream);
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 24;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqStartTrace2.getTotalBytes(this.fLineSeparator);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] FLAGS = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "Save Source")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Flags", EPDC_DumpUtils.getAttrbuteName(FLAGS, this.fFlags));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "LineSeperator", this.fLineSeparator);
    }

    @Override
    public String getDescription() {
        return "Start Trace Recording";
    }
}

