/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECCFileFilter;
import com.ibm.debug.pdt.internal.epdc.ECCFilter;
import com.ibm.debug.pdt.internal.epdc.ECCLineFilter;
import com.ibm.debug.pdt.internal.epdc.ECCModuleFilter;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class EReqStartCC
extends EPDC_Request {
    public static final byte LINE = 1;
    public static final byte FLOW = 2;
    public static final byte MODULE = 3;
    public static final byte TRACE = 4;
    public static final byte BRANCH = 5;
    public static final byte BRANCH_LINE = 6;
    public static final int DEFAULT = 1;
    public static final int LISTING_ONLY = 2;
    public static final int SOURCE_ONLY = 3;
    public static final int SOURCE_LISTING = 4;
    public static final ECCFilter[] EMPTYFILTERS = new ECCFilter[0];
    private byte fLevel;
    private int fView;
    private ECCFilter[] fFilters = EMPTYFILTERS;

    public EReqStartCC(byte level, int view, ECCFilter[] filters, EPDC_EngineSession engineSession) {
        super(237, engineSession);
        this.fLevel = level;
        this.fView = view;
        if (filters != null) {
            this.fFilters = Arrays.copyOf(filters, filters.length);
        }
    }

    EReqStartCC(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dis, engineSession);
        this.fLevel = dis.readByte();
        if (3 != dis.read(new byte[3])) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in EReqStartCC. loc 1", 2);
        }
        this.fView = dis.readInt();
        int numFilters = dis.readInt();
        this.fFilters = new ECCFilter[numFilters];
        OffsetDataInputStream filterStream = new OffsetDataInputStream(byteBuffer, dis.readInt());
        int i = 0;
        while (i < numFilters) {
            filterStream.mark(2);
            filterStream.readByte();
            byte filterType = dis.readByte();
            filterStream.reset();
            switch (filterType) {
                case 2: {
                    this.fFilters[i] = new ECCLineFilter(byteBuffer, filterStream, engineSession);
                    break;
                }
                case 1: {
                    this.fFilters[i] = new ECCFileFilter(byteBuffer, filterStream, engineSession);
                    break;
                }
                default: {
                    this.fFilters[i] = new ECCModuleFilter(byteBuffer, filterStream, engineSession);
                }
            }
            ++i;
        }
        if (8 != dis.read(new byte[8])) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in EReqStartCC. loc 2", 2);
        }
    }

    @Override
    void output(DataOutputStream dos) throws IOException {
        super.output(dos);
        dos.writeByte(this.fLevel);
        dos.write(new byte[3]);
        dos.writeInt(this.fView);
        dos.writeInt(this.fFilters.length);
        if (this.fFilters.length > 0) {
            int offset = this.getFixedLen() + super.getVarLen();
            dos.writeInt(offset);
            dos.write(new byte[8]);
            ECCFilter[] eCCFilterArray = this.fFilters;
            int n = this.fFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ECCFilter filter = eCCFilterArray[n2];
                filter.output(dos, offset);
                ++n2;
            }
        } else {
            dos.writeInt(0);
            dos.write(new byte[8]);
        }
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 24;
    }

    @Override
    int getVarLen() {
        int varLen = super.getVarLen();
        ECCFilter[] eCCFilterArray = this.fFilters;
        int n = this.fFilters.length;
        int n2 = 0;
        while (n2 < n) {
            ECCFilter filter = eCCFilterArray[n2];
            varLen += filter.getTotalBytes();
            ++n2;
        }
        return varLen;
    }

    @Override
    public void writeEPDC(DataOutputStream dos) throws IOException {
        EPDC_DumpUtils.writeVariable(dos, "CC Level", this.fLevel);
        EPDC_DumpUtils.writeVariable(dos, "View number", this.fView);
        EPDC_DumpUtils.writeVariable(dos, "Number of Filters", this.fFilters.length);
        if (this.fFilters.length > 0) {
            EPDC_DumpUtils.beginStructure(dos, "Filters");
            ECCFilter[] eCCFilterArray = this.fFilters;
            int n = this.fFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ECCFilter filter = eCCFilterArray[n2];
                filter.writeEPDC(dos);
                ++n2;
            }
            EPDC_DumpUtils.endStructure(dos);
        }
    }

    @Override
    public String getDescription() {
        return "Start CC capture";
    }
}

