/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextStackEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqStackBuildView
extends EPDC_Request {
    private int _threadID;
    private ERepGetNextStackEntry _stackEntry = null;
    private int _stackFrameID;
    private static final int FIXED_LENGTH = 8;

    public EReqStackBuildView(int threadID, ERepGetNextStackEntry stackEntry, EPDC_EngineSession engineSession) {
        super(15, engineSession);
        this._threadID = threadID;
        this._stackEntry = stackEntry;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._threadID);
        int id = 0;
        if (this._stackEntry == null) {
            id = this._stackFrameID;
        } else {
            id = this._stackEntry.getId();
            if (this._stackEntry.getEPDCEngineSession().useStackEntryIndex()) {
                id = this._stackEntry.getIndex();
            }
        }
        dataOutputStream.writeInt(id);
    }

    EReqStackBuildView(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._threadID = dataInputStream.readInt();
        this._stackFrameID = dataInputStream.readInt();
    }

    private int getStackFrameID() {
        if (this._stackEntry == null) {
            return this._stackFrameID;
        }
        return this._stackEntry.getId();
    }

    @Override
    int getFixedLen() {
        int total = 8 + super.getFixedLen();
        return total;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread ID", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Stack_Frame_ID", this.getStackFrameID());
    }

    @Override
    public String getDescription() {
        return "Get stack information";
    }
}

