/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EExtString;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqSourcePathUpdate
extends EPDC_Request {
    private EExtString _sourcePathString;
    private static final int FIXED_LENGTH = 8;

    public EReqSourcePathUpdate(String newPath, EPDC_EngineSession engineSession) {
        super(231, engineSession);
        this._sourcePathString = new EExtString(newPath, engineSession);
    }

    EReqSourcePathUpdate(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.skipBytes(4);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._sourcePathString = new EExtString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        dataOutputStream.writeInt(0);
        EReqSourcePathUpdate.writeOffsetOrZero(dataOutputStream, offset, this._sourcePathString);
        if (this._sourcePathString != null) {
            this._sourcePathString.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 8;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqSourcePathUpdate.getTotalBytes(this._sourcePathString);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "SourcePath", this._sourcePathString.toString());
    }

    @Override
    public String getDescription() {
        return "Update debug engine search paths";
    }
}

