/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqRepForTypeSet
extends EPDC_Request {
    private int _languageId;
    private int _typeIndex;
    private int _rep;
    private static final int FIXED_LENGTH = 12;

    EReqRepForTypeSet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._languageId = dataInputStream.readInt();
        this._typeIndex = dataInputStream.readInt();
        this._rep = dataInputStream.readInt();
    }

    public EReqRepForTypeSet(int languageId, int typeIndex, int rep, EPDC_EngineSession engineSession) {
        super(210, engineSession);
        this._languageId = languageId;
        this._typeIndex = typeIndex;
        this._rep = rep;
    }

    @Override
    int getFixedLen() {
        return 12 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._languageId);
        dataOutputStream.writeInt(this._typeIndex);
        dataOutputStream.writeInt(this._rep);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Language_ID", this._languageId);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type_Index", this._typeIndex);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Rep_Index", this._rep);
    }

    @Override
    public String getDescription() {
        return "Set default type";
    }
}

