/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqRemoteHalt
extends EPDC_Request {
    private int fThreadID = 0;

    public EReqRemoteHalt(int threadID, EPDC_EngineSession engineSession) {
        super(204, engineSession);
        this.fThreadID = threadID;
    }

    EReqRemoteHalt(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        if (this.getEPDCVersion() > 310) {
            this.fThreadID = dataInputStream.readInt();
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        if (this.getEPDCVersion() > 310) {
            dataOutputStream.writeInt(this.fThreadID);
        }
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() > 310) {
            return super.getFixedLen() + 4;
        }
        return super.getFixedLen();
    }

    public int getThreadID() {
        return this.fThreadID;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread ID", this.fThreadID);
    }

    @Override
    public String getDescription() {
        return "Halt program";
    }
}

