/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqRegistersValueSet
extends EPDC_Request {
    private int _threadID;
    private int _groupID;
    private int _registerID;
    private EStdString _newRegisterValue;
    private static final int FIXED_LENGTH = 16;

    EReqRegistersValueSet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._threadID = dataInputStream.readInt();
        this._groupID = dataInputStream.readInt();
        this._registerID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._newRegisterValue = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public EReqRegistersValueSet(int DU, int groupID, int id, String value, EPDC_EngineSession engineSession) {
        super(57, engineSession);
        this._threadID = DU;
        this._groupID = groupID;
        this._registerID = id;
        this._newRegisterValue = new EStdString(value, engineSession);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._threadID);
        dataOutputStream.writeInt(this._groupID);
        dataOutputStream.writeInt(this._registerID);
        int offset = this.getFixedLen() + super.getVarLen();
        EReqRegistersValueSet.writeOffsetOrZero(dataOutputStream, offset, this._newRegisterValue);
        if (this._newRegisterValue != null) {
            this._newRegisterValue.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Registers_DU", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Registers_Group_ID", this._groupID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Register_ID", this._registerID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "New_Register_Value", this._newRegisterValue);
    }

    @Override
    int getFixedLen() {
        return 16 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return EReqRegistersValueSet.getTotalBytes(this._newRegisterValue);
    }

    @Override
    public String getDescription() {
        return "Write to register";
    }
}

