/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqRegisters2
extends EPDC_Request {
    private int _threadID;
    private int _groupID;
    private int _registersAttr;
    private static final int FIXED_LENGTH = 12;

    public EReqRegisters2(int threadID, int groupID, int registersAttr, EPDC_EngineSession engineSession) {
        super(54, engineSession);
        this._threadID = threadID;
        this._groupID = groupID;
        this._registersAttr = registersAttr;
    }

    EReqRegisters2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._threadID = dataInputStream.readInt();
        this._groupID = dataInputStream.readInt();
        this._registersAttr = dataInputStream.readInt();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._threadID);
        dataOutputStream.writeInt(this._groupID);
        dataOutputStream.writeInt(this._registersAttr);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] regAttrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "Enabled")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Registers_DU", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Registers_Group_ID", this._groupID);
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Registers_Attr", this._registersAttr, regAttrConstants);
    }

    @Override
    int getFixedLen() {
        int total = 12 + super.getFixedLen();
        return total;
    }

    @Override
    public String getDescription() {
        return "Monitor registers";
    }
}

