/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdNameValuePair;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPutEventContent
extends EPDC_Request {
    private short fEventType;
    private EStdNameValuePair[] fFields;

    public EReqPutEventContent(short eventType, EStdNameValuePair[] fields, EPDC_EngineSession engineSession) {
        super(230, engineSession);
        this.fEventType = eventType;
        this.fFields = fields;
    }

    EReqPutEventContent(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fEventType = dataInputStream.readShort();
        dataInputStream.skipBytes(2);
        int numFields = dataInputStream.readInt();
        this.fFields = new EStdNameValuePair[numFields];
        int offset = dataInputStream.readInt();
        int i = 0;
        while (i < numFields) {
            OffsetDataInputStream os = new OffsetDataInputStream(byteBuffer, offset);
            this.fFields[i] = new EStdNameValuePair(byteBuffer, os, engineSession);
            offset += this.fFields[i].getTotalBytes();
            ++i;
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this.fEventType);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeInt(this.fFields.length);
        if (this.fFields.length == 0) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.getFixedLen());
            EStdNameValuePair[] eStdNameValuePairArray = this.fFields;
            int n = this.fFields.length;
            int n2 = 0;
            while (n2 < n) {
                EStdNameValuePair value = eStdNameValuePairArray[n2];
                value.output(dataOutputStream);
                ++n2;
            }
        }
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 12;
    }

    @Override
    int getVarLen() {
        int len = super.getVarLen();
        EStdNameValuePair[] eStdNameValuePairArray = this.fFields;
        int n = this.fFields.length;
        int n2 = 0;
        while (n2 < n) {
            EStdNameValuePair value = eStdNameValuePairArray[n2];
            len += value.getTotalBytes();
            ++n2;
        }
        return len;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Event type", this.fEventType);
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Name Value pairs");
        EStdNameValuePair[] eStdNameValuePairArray = this.fFields;
        int n = this.fFields.length;
        int n2 = 0;
        while (n2 < n) {
            EStdNameValuePair pair = eStdNameValuePairArray[n2];
            pair.writeEPDC(dataOutputStream);
            ++n2;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Send event fields";
    }
}

