/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqProcessDetach
extends EPDC_Request {
    private EStdString _processID;
    private int _detachAction;
    private static final int FIXED_LENGTH = 8;

    EReqProcessDetach(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int tempPid = dataInputStream.readInt();
        if (this.getEPDCVersion() < 308) {
            this._processID = new EStdString(Integer.toString(tempPid), engineSession);
        } else if (tempPid != 0) {
            this._processID = new EStdString(new OffsetDataInputStream(byteBuffer, tempPid), engineSession);
        }
        this._detachAction = dataInputStream.readInt();
    }

    public EReqProcessDetach(String processID, int detachAction, EPDC_EngineSession engineSession) {
        super(47, engineSession);
        this._immediate = false;
        if (processID != null) {
            this._processID = new EStdString(processID, engineSession);
        }
        this._detachAction = detachAction;
    }

    @Override
    int getFixedLen() {
        return 8 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        int total = 0;
        total += super.getVarLen();
        if (this.getEPDCVersion() > 307) {
            total += EReqProcessDetach.getTotalBytes(this._processID);
        }
        return total;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        if (this.getEPDCVersion() < 308) {
            int pid = 0;
            if (this._processID != null) {
                String tempPid = this._processID.toString();
                try {
                    pid = Integer.parseInt(tempPid);
                }
                catch (NumberFormatException e) {
                    pid = 0;
                }
            }
            dataOutputStream.writeInt(pid);
        } else {
            EReqProcessDetach.writeOffsetOrZero(dataOutputStream, offset, this._processID);
        }
        dataOutputStream.writeInt(this._detachAction);
        if (this.getEPDCVersion() > 307 && this._processID != null) {
            this._processID.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_ID", this._processID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_Detach_Action", this._detachAction);
    }

    @Override
    public String getDescription() {
        return "Detach from process";
    }
}

